/*******************************************************
Filename		:  DW_user_def_hab.sql
Release 		:  1594, 1595
SIR			:  c2.0.3
Description		:  Creates dummy Characterisitic for user def hab assessments and associates
			   the appropriate records from the hab assessment result fact table.  Also
			   updates STATION_CHAR and the station_visited flag in FA_STATION.
Author			:  Joseph Wilson
Date			:  4/12/2004
			   4/14/2004 - changed characterisitic name as requested at 4/13 CCB -JW
			   5/05/2004 - changed bio and reg counts from 0 to NULL -JW
03/02/2007 - ESE-WQX_DR_10 -GT
03/02/2007 -- edited to comment out first two statments for performance improvement.  -GT
Comments		:  999999 is used as the dummy fk_char value.
**********************************************************/

spool DW_user_def_hab.log
--commented out the following for performance issues.  Insert statement is moved to char_table.sql and the next update statement is accomodated in fa_habitat_result_table.sql -GT
/*
-- create user def hab assessment characteristic. This is moved to characteristic table creation to assign chartype appropriately.

insert into di_characteristic 
	values (999999,'USER DEFINED HABITAT CHARACTERISTIC', 'User Defined Habitat Characteristic','H');
*/
-- set fk_char for user def hab results
update fa_habitat_result set fk_char = 999999 where fk_char is null;
commit;


-- add entries with counts to station_char
/*
insert into station_char
	select 999999,
		fk_station,
		'User Defined Habitat Characteristic',
		'USER DEFINED HABITAT CHARACTERISTIC',
		'H',
		NULL,
		NULL,
		count(pk_isn),
		min(activity_start_date_time),
		max(activity_start_date_time),
		count(pk_isn)
	from fa_habitat_result
	where fk_char = 999999
	group by fk_station; 
*/

insert into station_char
(FK_CHAR                        ,
FK_FA_STATN                    ,
HYDROLOGIC_UNIT_CODE           ,
ORGANIZATION_ID                ,
STATION_ID                     ,
STATION_NAME                   ,
DISPLAY_NAME                   ,
SEARCH_NAME                    ,
CHAR_TYPE_CODE                 ,
REGULAR_COUNT                  ,
BIOLOGICAL_COUNT               ,
HABITAT_COUNT                  ,
ACT_MIN_START_DATE             ,
ACT_MAX_START_DATE             ,
ACT_MAX_START_STOP_DATE        ,
RESULT_COUNT                   )
	select 999999,
		fk_station,
                hydrologic_unit_code,
                organization_id,
                station_id,
		station_name,
		'User Defined Habitat Characteristic',
		'USER DEFINED HABITAT CHARACTERISTIC',
		'H',
		NULL,
		NULL,
		count(pk_isn),
		min(activity_start_date_time),
		max(activity_start_date_time),
		max(case when (activity_stop_date_time is not null and activity_stop_date_time > activity_start_date_time) then 
			activity_stop_date_time
                    else activity_start_date_time
                    end),
		count(pk_isn)
	from fa_habitat_result
	where fk_char = 999999
	group by fk_station,hydrologic_unit_code,organization_id,station_id,station_name; 
commit;



-- move station_visited logic or run the following:
update fa_station set station_visited = 'YES'
	where station_visited is null
	and pk_isn in (
		select fk_fa_statn from station_char
		where fk_char = 999999);
COMMIT;

SPOOL OFF;